#include "../bdtypes.h"
#include "../bdfunc.h"
#include "../bdglobal.h"
#include "../generator.h"

static GrVertex Mosaic[1024][4];
static float MosaicTanTab[32*32];
static float MosaicDistTab[32*32];

static Obj3d* pCube;
static Obj3d *pFace1, *pFace2, *pFace3, *pFace4, *pFace5;
static float Matrix[16];
static float Matrix2[16];

void LInit_Mosaic()
{
	int Cpt1, Cpt2;

	pCube = GenerateFloor(2,2, 200, 200, 256, 256);
	BeIdentityMatrix(Matrix);
	TranslateMatrix(Matrix, 0,0,200);
	ApplyMatrix(pCube, Matrix);
	
	pFace1 = CopyObj(pCube);
	pFace2 = CopyObj(pCube);
	pFace3 = CopyObj(pCube);
	pFace4 = CopyObj(pCube);
	pFace5 = CopyObj(pCube);

	BeIdentityMatrix(Matrix);
	RotateXMatrix(Matrix2, Matrix, 8192/4); // PI/2
	ApplyMatrix(pFace1, Matrix2);

	BeIdentityMatrix(Matrix);
	RotateXMatrix(Matrix2, Matrix, 8192/2); // PI
	ApplyMatrix(pFace2, Matrix2);

	BeIdentityMatrix(Matrix);
	RotateXMatrix(Matrix2, Matrix, 8192*3/4); // PI*3/2
	ApplyMatrix(pFace3, Matrix2);

	BeIdentityMatrix(Matrix);
	RotateYMatrix(Matrix2, Matrix, 8192/4); // PI/2
	ApplyMatrix(pFace4, Matrix2);

	BeIdentityMatrix(Matrix);
	RotateYMatrix(Matrix2, Matrix, -8192/4); // -PI/2
	ApplyMatrix(pFace5, Matrix2);

	pCube = CombineObj(pCube, pFace1);
	pCube = CombineObj(pCube, pFace2);
	pCube = CombineObj(pCube, pFace3);
	pCube = CombineObj(pCube, pFace4);
	pCube = CombineObj(pCube, pFace5);

	DeleteObj(pFace1);
	DeleteObj(pFace2);
	DeleteObj(pFace3);
	DeleteObj(pFace4);
	DeleteObj(pFace5);

	
	
	for(Cpt1=0;Cpt1<32;Cpt1++)
	{
		for(Cpt2=0;Cpt2<32;Cpt2++)
		{
			Mosaic[Cpt1*32+Cpt2][0].x = Cpt2/32.f*635.f;
			Mosaic[Cpt1*32+Cpt2][0].y = Cpt1/32.f*475.f;
			Mosaic[Cpt1*32+Cpt2][1].x = Cpt2/32.f*635.f+22;
			Mosaic[Cpt1*32+Cpt2][1].y = Cpt1/32.f*475.f;
			Mosaic[Cpt1*32+Cpt2][2].x = Cpt2/32.f*635.f+22;
			Mosaic[Cpt1*32+Cpt2][2].y = Cpt1/32.f*475.f+20;
			Mosaic[Cpt1*32+Cpt2][3].x = Cpt2/32.f*635.f;
			Mosaic[Cpt1*32+Cpt2][3].y = Cpt1/32.f*475.f+20;
			Mosaic[Cpt1*32+Cpt2][0].r = (float)(rand()&255);
			Mosaic[Cpt1*32+Cpt2][0].g = (float)(rand()&255);
			Mosaic[Cpt1*32+Cpt2][0].b = (float)(rand()&255);
			Mosaic[Cpt1*32+Cpt2][1].r = 0;
			Mosaic[Cpt1*32+Cpt2][1].g = 0;
			Mosaic[Cpt1*32+Cpt2][1].b = 0;
			Mosaic[Cpt1*32+Cpt2][2].r = 0;
			Mosaic[Cpt1*32+Cpt2][2].g = 0;
			Mosaic[Cpt1*32+Cpt2][2].b = 0;
			Mosaic[Cpt1*32+Cpt2][3].r = (float)((g_PicNoirBlanc[Cpt1*128*4+Cpt2*4]&31)*8);
			Mosaic[Cpt1*32+Cpt2][3].g = (float)(((g_PicNoirBlanc[Cpt1*128*4+Cpt2*4]&(31<<6))>>6)*8);
			Mosaic[Cpt1*32+Cpt2][3].b = (float)(((g_PicNoirBlanc[Cpt1*128*4+Cpt2*4]&(31<<11))>>11)*8);
		}
	}

	for(Cpt1=0;Cpt1<32;Cpt1++)
	{
		for(Cpt2=0;Cpt2<32;Cpt2++)
		{
			MosaicTanTab[Cpt1*32+Cpt2] = (float)cos(atan2(Cpt1-16, Cpt2-16))*63.f+64;
			MosaicDistTab[Cpt1*32+Cpt2] = 8*(float)sqrt((Cpt1-16)*(Cpt1-16)+(Cpt2-16)*(Cpt2-16));
		}
	}

	PrepareTextureFromArray(g_PicCiel, 256, 256, &g_TextureCiel);
}

void QInit_Mosaic()
{
	grConstantColorValue((128<<24));

	grDepthBufferMode(GR_DEPTHBUFFER_DISABLE);
	grAlphaCombine(GR_COMBINE_FUNCTION_BLEND_OTHER, GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_CONSTANT, FXFALSE);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ONE,
							GR_BLEND_ONE, GR_BLEND_ZERO);
	grColorCombine(GR_COMBINE_FUNCTION_LOCAL,
					GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_NONE, FXFALSE);
	grCullMode(GR_CULL_DISABLE);
	grFogMode(GR_FOG_DISABLE);

	g_demostate.ClearColor = 0;

	grChromakeyMode(GR_CHROMAKEY_DISABLE);
	DownloadTexture(&g_TextureCiel);
	SelectTexture(g_TextureCiel);
}

void Effect_Mosaic()
{
	int Img1, Cpt1;

	Img1 = g_demostate.TickInEffect/10;

	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ONE,
							GR_BLEND_ONE, GR_BLEND_ZERO);
	grColorCombine(GR_COMBINE_FUNCTION_LOCAL,
					GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_NONE, FXFALSE);

	for(Cpt1=0;Cpt1<1024;Cpt1++)
	{
		Mosaic[Cpt1][0].r = 
			MosaicTanTab[Cpt1]+(Img1&255);
		if (Mosaic[Cpt1][0].r>255)
			Mosaic[Cpt1][0].r -= 255;
		Mosaic[Cpt1][0].g = Mosaic[Cpt1][0].r;
		Mosaic[Cpt1][0].b = Mosaic[Cpt1][0].r;
		Mosaic[Cpt1][0].r = 0;
		grDrawTriangle(&Mosaic[Cpt1][0], &Mosaic[Cpt1][1], &Mosaic[Cpt1][2]);
		grDrawTriangle(&Mosaic[Cpt1][2], &Mosaic[Cpt1][3], &Mosaic[Cpt1][0]);
	}

	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
	grAlphaCombine(GR_COMBINE_FUNCTION_BLEND_OTHER, GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_CONSTANT, FXFALSE);
	grAlphaBlendFunction(GR_BLEND_SRC_ALPHA, GR_BLEND_ONE_MINUS_SRC_ALPHA, GR_BLEND_ZERO, GR_BLEND_ZERO);

	BeIdentityMatrix(Matrix);

	ScaleXMatrix(Matrix, (float)cos(Img1/40.f)/1.5f+1.f);
	ScaleYMatrix(Matrix, (float)cos(Img1/40.f+2)/1.5f+1.f);
	ScaleZMatrix(Matrix, (float)cos(Img1/40.f+4)/1.5f+1.f);

	RotateXMatrix(Matrix2, Matrix, g_demostate.TickInEffect); // 1/160
	RotateYMatrix(Matrix, Matrix2, g_demostate.TickInEffect);
	RotateZMatrix(Matrix2, Matrix, g_demostate.TickInEffect);

	TranslateMatrix(Matrix2, 0, 0, 700);
	DrawWithMatrix(pCube, Matrix2, false, NULL, 0);
}

void ByeBye_Mosaic()
{
	FreeTexture(&g_TextureCiel);
}